/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PED_ELTR_COT]    Script Date: 29/08/2014 16:36:51 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PED_ELTR_COT]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PED_ELTR_COT]
GO  
--SELECT * FROM UFD_EST_PED_ELTR_COT(1,927)
CREATE   FUNCTION [dbo].[UFD_EST_PED_ELTR_COT](
												@CD_EMP			INT,
												@CD_PED_SOL		INT
												)
RETURNS @RS_RETORNO	TABLE (
									CD_EMP				 INT,
									CD_PED_SOL			 INT,
									CD_FIL_ENTR			 INT,
									CD_FORN				 INT,
									CD_PROD				 INT,
									DS_PROD				 VARCHAR(150),
									DS_UN				 VARCHAR(5),
									VLR_CUSTO			 MONEY,
									QT_IT_UN    		 MONEY,
									QT_IT_SOLI   		 MONEY,
									CD_PED_CP			 INT,
									QT_IT_CP			 MONEY,
									QT_IT_SLD			 MONEY,
									VLR_IT_CP			 MONEY,
									STS_PED				 INT,    
									DT_PED				 DATETIME, 
								    DT_ENTR				 DATETIME, 
									CD_FIL_FAT			 INT, 
									DT_ULT_ATU			 DATETIME, 
									CD_USU				 INT, 
									DT_CAD				 DATETIME, 
								    TP_REQ				 INT,
									PERC_DESC			 MONEY,
									FLAG_GERAR_CROSS	 INT,
									MEDIAF				 MONEY,
									QT_EST				 MONEY,
									CD_COND_COMPRA		 INT,
									NM_FANT              VARCHAR(160),
									DT_FATURAMENTO		 DATETIME,
									EAN                  VARCHAR(20),
									NM_FABRICANTE	     VARCHAR(200),
									PERC_DESC_FINANCEIRO MONEY)
AS 
BEGIN
DECLARE @RS_PED_ELETR	TABLE(
									CD_EMP				 INT,
									CD_PED_SOL			 INT,
									CD_FIL_ENTR			 INT,
									CD_FORN				 INT,
									CD_PROD				 INT,
									QT_IT_UN    		 MONEY,
									QT_IT_SOLI   		 MONEY,
									CD_PED_CP			 INT,
									QT_IT_CP			 MONEY,
									QT_IT_SLD			 MONEY,
									VLR_IT_CP			 MONEY,
									STS_PED				 INT,    
									DT_PED				 DATETIME, 
								    DT_ENTR				 DATETIME, 
									CD_FIL_FAT			 INT, 
									DT_ULT_ATU			 DATETIME, 
									CD_USU				 INT, 
									DT_CAD				 DATETIME, 
								    TP_REQ				 INT,
									PERC_DESC			 MONEY,
									FLAG_GERAR_CROSS	 INT,
									CD_COND_COMPRA		 INT,
									DT_FATURAMENTO		 DATETIME,
									PERC_DESC_FINANCEIRO MONEY)

DECLARE @RS_PED_CP TABLE(
							 CD_EMP			INT,
							 CD_PED_SOL		INT,
							 CD_FORN			INT,
							 CD_PED_CP		INT,	
							 CD_PROD			INT,
 							 QT_IT_CP		MONEY,
							 VLR_IT_CP		MONEY)
							

    INSERT INTO @RS_PED_ELETR
	SELECT     
		EST_PED_ELTR.CD_EMP, 
		EST_PED_ELTR.CD_PED_SOL, 
		EST_PED_ELTR.CD_FIL_ENTR, 
	    0 AS CD_FORN, 
		EST_PED_ELTR_IT.CD_PROD,
		EST_PED_ELTR_IT.QT_IT_UN,
		EST_PED_ELTR_IT.QT_IT,
		0,
		0,
		EST_PED_ELTR_IT.QT_IT,
		EST_PED_ELTR_IT.VLR_PROD,
		EST_PED_ELTR.STS_PED,    
		EST_PED_ELTR.DT_PED, 
	    EST_PED_ELTR.DT_ENTR, 
		EST_PED_ELTR.CD_FIL_FAT, 
		EST_PED_ELTR.DT_ULT_ATU, 
		EST_PED_ELTR.CD_USU, 
		EST_PED_ELTR.DT_CAD, 
	    EST_PED_ELTR.TP_REQ,
		EST_PED_ELTR_IT.PERC_DESC,
		ISNULL(EST_PED_ELTR.FLAG_GERAR_CROSS,0),
		ISNULL(EST_PED_ELTR_IT.CD_COND_COMPRA,0) CD_COND_COMPRA,
		ISNULL(EST_PED_ELTR.DT_FATURAMENTO,EST_PED_ELTR.DT_CAD) AS DT_FATURAMENTO,
		ISNULL(EST_PED_ELTR_IT.PERC_DESC_FINANCEIRO,0) AS PERC_DESC_FINANCEIRO
	FROM         
		EST_PED_ELTR INNER JOIN EST_PED_ELTR_IT ON 
		EST_PED_ELTR.CD_EMP = EST_PED_ELTR_IT.CD_EMP AND 
		EST_PED_ELTR.CD_PED_SOL = EST_PED_ELTR_IT.CD_PED_SOL 
	WHERE     
		EST_PED_ELTR.CD_EMP = @CD_EMP
		AND EST_PED_ELTR.CD_PED_SOL = @CD_PED_SOL
		AND EST_PED_ELTR.TP_REQ = 1

INSERT INTO @RS_PED_CP
	SELECT     
		EST_PED_ELTR_FORN_PED_CP.CD_EMP, 
		EST_PED_ELTR_FORN_PED_CP.CD_PED_SOL, 
		EST_PED_CP.CD_FORN, 
		EST_PED_CP.CD_PED,
	    EST_PED_CP_IT.CD_PROD, 
		EST_PED_CP_IT.QT_IT, 
		EST_PED_CP_IT.VLR_IT
	FROM         
		EST_PED_ELTR_FORN_PED_CP INNER JOIN EST_PED_CP ON 
		EST_PED_ELTR_FORN_PED_CP.CD_EMP = EST_PED_CP.CD_EMP AND 
	    EST_PED_ELTR_FORN_PED_CP.CD_FIL_ENTR = EST_PED_CP.CD_FILIAL AND 
	    EST_PED_ELTR_FORN_PED_CP.CD_PED = EST_PED_CP.CD_PED 
		INNER JOIN EST_PED_CP_IT ON 
		EST_PED_CP.CD_EMP = EST_PED_CP_IT.CD_EMP AND 
		EST_PED_CP.CD_FILIAL = EST_PED_CP_IT.CD_FILIAL AND 
	    EST_PED_CP.CD_PED = EST_PED_CP_IT.CD_PED
	WHERE     
		EST_PED_ELTR_FORN_PED_CP.CD_EMP = @CD_EMP
		AND EST_PED_ELTR_FORN_PED_CP.CD_PED_SOL = @CD_PED_SOL

UPDATE 
	@RS_PED_ELETR
SET
    CD_FORN     = RS_PED_CP.CD_FORN, 
	CD_PED_CP 	= RS_PED_CP.CD_PED_CP,
	VLR_IT_CP	= RS_PED_CP.VLR_IT_CP,
	QT_IT_CP 	= RS_PED_CP.QT_IT_CP,
	QT_IT_SLD 	= RS_PED_ELETR.QT_IT_SOLI - RS_PED_CP.QT_IT_CP
FROM 
	@RS_PED_ELETR RS_PED_ELETR,
	@RS_PED_CP RS_PED_CP
WHERE
	RS_PED_ELETR.CD_EMP = RS_PED_CP.CD_EMP AND 
	RS_PED_ELETR.CD_PED_SOL = RS_PED_CP.CD_PED_SOL AND 
	RS_PED_ELETR.CD_PROD = RS_PED_CP.CD_PROD


INSERT INTO @RS_RETORNO
	SELECT 
		RS_PED_ELETR.CD_EMP, 
		RS_PED_ELETR.CD_PED_SOL,
		RS_PED_ELETR.CD_FIL_ENTR,
		RS_PED_ELETR.CD_FORN, 
		RS_PED_ELETR.CD_PROD, 
		EST_PROD.DS_PROD,
		EST_PROD_UN_MED.DS_UN,
		EST_PROD.VLR_CUSTO_GRP,
		RS_PED_ELETR.QT_IT_UN,
		RS_PED_ELETR.QT_IT_SOLI, 
		RS_PED_ELETR.CD_PED_CP,   
		RS_PED_ELETR.QT_IT_CP,              
		RS_PED_ELETR.QT_IT_SLD,             
		RS_PED_ELETR.VLR_IT_CP,            
		RS_PED_ELETR.STS_PED, 
		RS_PED_ELETR.DT_PED,
		RS_PED_ELETR.DT_ENTR,
		RS_PED_ELETR.CD_FIL_FAT,
		RS_PED_ELETR.DT_ULT_ATU,
		RS_PED_ELETR.CD_USU,
		RS_PED_ELETR.DT_CAD,
		RS_PED_ELETR.TP_REQ,
		RS_PED_ELETR.PERC_DESC,
		RS_PED_ELETR.FLAG_GERAR_CROSS,
		EST_PROD_CPL.MEDIAF,
		EST_PROD_CPL.QT_EST,
		RS_PED_ELETR.CD_COND_COMPRA,
		LEFT(PG_FORN.NM_FANT,16) AS NM_FANT,
		DT_FATURAMENTO,
		(SELECT MAX(CD_BARRA)
        FROM
           EST_PROD_CD_BARRA
		WHERE
			EST_PROD_CD_BARRA.CD_EMP = EST_PROD.CD_EMP AND
			EST_PROD_CD_BARRA.CD_PROD = EST_PROD.CD_PROD AND
			EST_PROD_CD_BARRA.EAN_CAIXA_FECHADA = 0 AND ISNULL(FLAG_PRE_VENCIDOS,0) = 0 ) AS CD_BARRA,
		NM_FABRIC,
		ISNULL(RS_PED_ELETR.PERC_DESC_FINANCEIRO,0) AS PERC_DESC_FINANCEIRO
	FROM 
		@RS_PED_ELETR RS_PED_ELETR
		INNER JOIN   EST_PROD ON 
		RS_PED_ELETR.CD_EMP  = EST_PROD.CD_EMP    AND
		RS_PED_ELETR.CD_PROD = EST_PROD.CD_PROD 	
		   	
		INNER JOIN  EST_PROD_UN_MED ON  
		EST_PROD.CD_EMP   = EST_PROD_UN_MED.CD_EMP   AND
		EST_PROD.CD_UN_CP = EST_PROD_UN_MED.CD_CTR_UN
		
		INNER JOIN  EST_PROD_CPL ON 
		RS_PED_ELETR.CD_EMP		 =  EST_PROD_CPL.CD_EMP  AND
		RS_PED_ELETR.CD_FIL_ENTR =  EST_PROD_CPL.CD_FILIAL AND
		RS_PED_ELETR.CD_PROD	 =  EST_PROD_CPL.CD_PROD	 
		LEFT OUTER JOIN PG_FORN ON
		RS_PED_ELETR.CD_EMP = PG_FORN.CD_EMP AND
		RS_PED_ELETR.CD_FORN = PG_FORN.CD_FORN 
		INNER JOIN EST_PROD_FABRIC ON
		EST_PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC
	WHERE
		EST_PROD_CPL.CD_EMP = @CD_EMP
	ORDER BY
		EST_PROD.DS_PROD
RETURN
END

GO


